package com.ejie.aa17a.control;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.aa17a.model.Aa17aAviso;
import com.ejie.aa17a.model.Aa17aBanda;
import com.ejie.aa17a.model.Aa17aContaminante;
import com.ejie.aa17a.model.Aa17aDatoHistorico;
import com.ejie.aa17a.model.Aa17aDatoHorario;
import com.ejie.aa17a.model.Aa17aEstacion;
import com.ejie.aa17a.service.iface.Aa17aAvisoService;
import com.ejie.aa17a.service.iface.Aa17aBandaService;
import com.ejie.aa17a.service.iface.Aa17aContaminanteService;
import com.ejie.aa17a.service.iface.Aa17aDatoHistoricoService;
import com.ejie.aa17a.service.iface.Aa17aDatoHorarioService;
import com.ejie.aa17a.service.iface.Aa17aEstacionService;
import com.ejie.aa17a.utilidades.Aa17aConstantes;

/**
 * Aa17aRegistroMaestroController generated by UDA, 18-dic-2013 15:36:30.
 * 
 * @author UDA
 */

@RequestMapping(value = "/datos")
public class Aa17aDatosController {

	private static final Logger logger = LoggerFactory.getLogger(Aa17aDatosController.class);

	private Aa17aEstacionService aa17aEstacionService;
	private Aa17aAvisoService aa17aAvisoService;
	private Aa17aDatoHorarioService aa17aDatoHorarioService;
	private Aa17aBandaService aa17aBandaService;
	private Aa17aContaminanteService aa17aContaminanteService;
	private Aa17aDatoHistoricoService aa17aDatoHistoricoService;

	/**
	 * Method 'getEstaciones'.
	 * 
	 * @return List<Aa17aEstacion>
	 */
	@RequestMapping(value = "estaciones", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa17aEstacion> getEstaciones() {
		Aa17aDatosController.logger.info("[GET - View] : getEstaciones");

		Aa17aEstacion filterAa17aEstacion = new Aa17aEstacion();
		filterAa17aEstacion.setEstado(Aa17aConstantes.ESTADO_ACTIVO); //busco solo las estaciones activas
		return this.aa17aEstacionService.findAll(filterAa17aEstacion);
	}

	/**
	 * detalleEstacion
	 * 
	 * @param idEstacion
	 *            Long
	 * @return Aa17aEstacion
	 */
	@RequestMapping(value = "estacion/detalle/{idEstacion}", method = RequestMethod.GET)
	public @ResponseBody
	Aa17aEstacion detalleEstacion(@PathVariable Long idEstacion) {
		Aa17aDatosController.logger.info("[GET - View] : detalleEstacion");

		//Obtengo los datos de la estacion
		Aa17aEstacion filterAa17aEstacion = new Aa17aEstacion();
		filterAa17aEstacion.setIdEstacion(idEstacion);
		return this.aa17aEstacionService.getEstacionConBanda(filterAa17aEstacion);
	}

	/**
	 * avisosEstacion
	 * 
	 * @param idEstacion
	 *            Long
	 * @return List<Aa17aAviso>
	 */
	@RequestMapping(value = "estacion/avisos/{idEstacion}", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa17aAviso> avisosEstacion(@PathVariable Long idEstacion) {
		Aa17aDatosController.logger.info("[GET - View] : avisosEstacion");

		//obtengo la lista de avisos de la estacion
		Aa17aAviso filterAa17aAviso = new Aa17aAviso();
		filterAa17aAviso.setEstado(Aa17aConstantes.ESTADO_ACTIVO);//busco solo los que estén activos
		filterAa17aAviso.setIdEstacion(idEstacion);
		return this.aa17aAvisoService.findAll(filterAa17aAviso);

	}

	/**
	 * datosHorariosEstacion
	 * 
	 * @param idEstacion
	 *            Long
	 * @return List<Aa17aDatoHorario>
	 */
	@RequestMapping(value = "estacion/horarios/{idEstacion}", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa17aDatoHorario> datosHorariosEstacion(@PathVariable Long idEstacion) {
		Aa17aDatosController.logger.info("[GET - View] : datosHorariosEstacion");

		Aa17aDatoHorario datoHorarioFiltro = new Aa17aDatoHorario();
		datoHorarioFiltro.setIdEstacion(idEstacion);

		//obtengo la ultima fecha de la que se tenga información de datos horarios de algún contaminante
		Date fechaUltimaMedicion = this.aa17aDatoHorarioService.getUltimaFechaMedida(datoHorarioFiltro);

		List<Aa17aDatoHorario> listDatosHorarios = new ArrayList<Aa17aDatoHorario>();

		//si tengo fecha de ultima medicion
		if (fechaUltimaMedicion != null) {
			//obtengo los datos horarios de esta fecha para la estacion
			datoHorarioFiltro.setFechaDato(fechaUltimaMedicion);
			listDatosHorarios = this.aa17aDatoHorarioService.findAll(datoHorarioFiltro);

			//si tengo datos, obtengo la fecha + hora de la ultima medicion
			if (listDatosHorarios != null && listDatosHorarios.size() > 0) {

				Aa17aDatoHistorico datoHistoricoFiltro = new Aa17aDatoHistorico();
				datoHistoricoFiltro.setIdEstacion(idEstacion);

				Aa17aBanda bandaFiltro = new Aa17aBanda();

				for (Aa17aDatoHorario datoHorario : listDatosHorarios) {

					/*
					 * si se trata de un parametro de tipo Contaminante y además tiene configurado un tipo de cálculo de ICA,
					 * obtengo los datos de la banda correspondiente
					 */
					if (datoHorario.getContaminante().getTipoParametro().equals(Aa17aConstantes.TIPO_PARAMETRO_CONTAMINANTE) &&
							datoHorario.getContaminante().getTipoCalculoICA() != null && datoHorario.getContaminante().getTipoCalculoICA() != Aa17aConstantes.MAGIC_NUMBER_0) {
						datoHistoricoFiltro.setContaminante(datoHorario.getContaminante());

						Long idBanda = this.aa17aDatoHistoricoService.getIdBandaContaminante(datoHistoricoFiltro);
						if (idBanda == null) {
							idBanda = Aa17aConstantes.ID_BANDA_SIN_DATOS; //si no tienen datos, muestro el icono azul de no hay datos
						}

						bandaFiltro.setIdBanda(idBanda);
						datoHorario.setBanda(this.aa17aBandaService.find(bandaFiltro));
					}
				}
			}

		}
		return listDatosHorarios;

	}

	/**
	 * Method 'getListaBandas'.
	 * 
	 * @return List<Aa17aBanda>
	 */
	@RequestMapping(value = "bandas", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa17aBanda> getListaBandas() {
		Aa17aDatosController.logger.info("[GET - View] : getListaBandas");

		//obtengo la lista de bandas
		Aa17aBanda filtroBanda = new Aa17aBanda();
		filtroBanda.setEstado(Aa17aConstantes.ESTADO_ACTIVO);
		return this.aa17aBandaService.findAll(filtroBanda);
	}

	/**
	 * Method 'getListaParametro'.
	 * 
	 * @return List<Aa17aContaminante>
	 */
	@RequestMapping(value = "parametros", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa17aContaminante> getListaParametro() {
		Aa17aDatosController.logger.info("[GET - View] : getListaParametro");

		Aa17aContaminante filtroContaminante = new Aa17aContaminante();
		filtroContaminante.setEstado(Aa17aConstantes.ESTADO_ACTIVO);
		return this.aa17aContaminanteService.findAll(filtroContaminante);
	}

	/**
	 * Method 'getEstacionesMapa'. Devuelve la lista de estaciones con la
	 * información de la banda correspondiente
	 * 
	 * @return List<Aa17aEstacion>
	 */
	@RequestMapping(value = "estaciones/mapa", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa17aEstacion> getEstacionesMapa() {
		Aa17aDatosController.logger.info("[GET - View] : getEstacionesMapa");

		Aa17aEstacion filterAa17aEstacion = new Aa17aEstacion();
		filterAa17aEstacion.setEstado(Aa17aConstantes.ESTADO_ACTIVO); //busco solo las estaciones activas
		return this.aa17aEstacionService.getListEstacionesConBanda(filterAa17aEstacion);
	}

	/**
	 * @param aa17aEstacionService
	 *            the aa17aEstacionService to set
	 */
	public void setAa17aEstacionService(Aa17aEstacionService aa17aEstacionService) {
		this.aa17aEstacionService = aa17aEstacionService;
	}

	/**
	 * @param aa17aAvisoService
	 *            the aa17aAvisoService to set
	 */
	public void setAa17aAvisoService(Aa17aAvisoService aa17aAvisoService) {
		this.aa17aAvisoService = aa17aAvisoService;
	}

	/**
	 * @param aa17aDatoHorarioService
	 *            the aa17aDatoHorarioService to set
	 */
	public void setAa17aDatoHorarioService(Aa17aDatoHorarioService aa17aDatoHorarioService) {
		this.aa17aDatoHorarioService = aa17aDatoHorarioService;
	}

	/**
	 * @param aa17aBandaService
	 *            the aa17aBandaService to set
	 */
	public void setAa17aBandaService(Aa17aBandaService aa17aBandaService) {
		this.aa17aBandaService = aa17aBandaService;
	}

	/**
	 * @param aa17aContaminanteService
	 *            the aa17aContaminanteService to set
	 */
	public void setAa17aContaminanteService(Aa17aContaminanteService aa17aContaminanteService) {
		this.aa17aContaminanteService = aa17aContaminanteService;
	}

	/**
	 * @param aa17aDatoHistoricoService
	 *            the aa17aDatoHistoricoService to set
	 */
	public void setAa17aDatoHistoricoService(Aa17aDatoHistoricoService aa17aDatoHistoricoService) {
		this.aa17aDatoHistoricoService = aa17aDatoHistoricoService;
	}

}
